/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.element.registry;

import com.fuzs.puzzleslib_em.PuzzlesLib;
import com.fuzs.puzzleslib_em.config.ConfigManager;
import com.fuzs.puzzleslib_em.element.AbstractElement;
import com.fuzs.puzzleslib_em.element.side.IClientElement;
import com.fuzs.puzzleslib_em.element.side.ICommonElement;
import com.fuzs.puzzleslib_em.element.side.IServerElement;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ElementRegistry {
    private static final BiMap<ResourceLocation, AbstractElement> ELEMENTS = HashBiMap.create();
    private static final TreeMap<String, AbstractElement> MOD_ELEMENTS = Maps.newTreeMap();

    public static <T extends AbstractElement> AbstractElement register(String key, Supplier<T> supplier) {
        return ElementRegistry.register(key, supplier, FMLEnvironment.dist);
    }

    @Nullable
    public static <T extends AbstractElement> AbstractElement register(String key, Supplier<T> supplier, Dist dist) {
        if (dist == FMLEnvironment.dist) {
            AbstractElement element = (AbstractElement)supplier.get();
            assert (element instanceof ICommonElement || FMLEnvironment.dist.isClient() || element instanceof IServerElement) : "Unable to register element: Trying to register client element for server side";
            assert (element instanceof ICommonElement || FMLEnvironment.dist.isDedicatedServer() || element instanceof IClientElement) : "Unable to register element: Trying to register server element for client side";
            MOD_ELEMENTS.put(key, element);
            return element;
        }
        return null;
    }

    @Nullable
    protected static <T extends AbstractElement> AbstractElement register(String namespace, String key, Supplier<T> supplier, Dist dist) {
        if (dist == FMLEnvironment.dist) {
            AbstractElement element = (AbstractElement)supplier.get();
            assert (element instanceof ICommonElement || FMLEnvironment.dist.isClient() || element instanceof IServerElement) : "Unable to register element: Trying to register client element for server side";
            assert (element instanceof ICommonElement || FMLEnvironment.dist.isDedicatedServer() || element instanceof IClientElement) : "Unable to register element: Trying to register server element for client side";
            ELEMENTS.put((Object)new ResourceLocation(namespace, key), (Object)element);
            return element;
        }
        return null;
    }

    public static ResourceLocation getRegistryName(AbstractElement element) {
        return (ResourceLocation)ELEMENTS.inverse().get((Object)element);
    }

    public static Optional<AbstractElement> get(String namespace, String key) {
        return Optional.ofNullable(ELEMENTS.get((Object)new ResourceLocation(namespace, key)));
    }

    public static <T> Optional<T> getConfigValue(String namespace, String key, Class<T> type, String ... path) {
        Optional<AbstractElement> element = ElementRegistry.get(namespace, key);
        if (element.isPresent()) {
            return ElementRegistry.getConfigValue(element.get(), type, path);
        }
        PuzzlesLib.LOGGER.error("Unable to get config value: Invalid element location");
        return Optional.empty();
    }

    public static <T> Optional<T> getConfigValue(AbstractElement element, Class<T> type, String ... path) {
        if (element.isEnabled()) {
            assert (path.length != 0) : "Unable to get config value: Invalid config path";
            String fullPath = Stream.concat(Stream.of(ElementRegistry.getRegistryName(element).func_110623_a()), Stream.of(path)).collect(Collectors.joining("."));
            return Optional.of(ConfigManager.get().getValue(fullPath));
        }
        return Optional.empty();
    }

    public static void setup(String namespace) {
        assert (!MOD_ELEMENTS.isEmpty()) : "Unable to setup elements for " + namespace + ": No elements registered";
        MOD_ELEMENTS.forEach((key, value) -> {
            AbstractElement cfr_ignored_0 = (AbstractElement)ELEMENTS.put((Object)new ResourceLocation(namespace, key), value);
        });
        ElementRegistry.setupGeneralSide(MOD_ELEMENTS.values(), element -> element instanceof ICommonElement, ModConfig.Type.COMMON, FMLEnvironment.dist);
        ElementRegistry.setupGeneralSide(MOD_ELEMENTS.values(), element -> element instanceof IClientElement && !(element instanceof ICommonElement), ModConfig.Type.CLIENT, Dist.CLIENT);
        ElementRegistry.setupGeneralSide(MOD_ELEMENTS.values(), element -> element instanceof IServerElement && !(element instanceof ICommonElement), ModConfig.Type.SERVER, Dist.DEDICATED_SERVER);
        MOD_ELEMENTS.values().forEach(AbstractElement::setup);
        MOD_ELEMENTS.clear();
    }

    private static void setupGeneralSide(Collection<AbstractElement> elements, Predicate<AbstractElement> isCurrentSide, ModConfig.Type type, Dist dist) {
        Set sideElements = elements.stream().filter(isCurrentSide).collect(Collectors.toSet());
        if (!sideElements.isEmpty()) {
            assert (dist == FMLEnvironment.dist) : "Unable to setup element: Sided element registered on common side";
            ConfigManager.builder().create("general", builder -> sideElements.forEach(element -> element.setupGeneralConfig((ForgeConfigSpec.Builder)builder)), type, new String[0]);
        }
    }

    private static Set<AbstractElement> getOwnElements(String namespace) {
        return ELEMENTS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).func_110624_b().equals(namespace)).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public static void load(ParallelDispatchEvent evt) {
        ELEMENTS.values().forEach(element -> element.load(evt));
    }
}

